<%@ Register TagPrefix="ibn" TagName="BlockHeader" src="..\Modules\BlockHeader.ascx" %>
<%@ Control Language="c#" AutoEventWireup="false" Codebehind="Sites.ascx.cs" Inherits="Mediachase.UI.ASP.Web.Modules.Sites" TargetSchema="http://schemas.microsoft.com/intellisense/ie5" %>
<TABLE cellSpacing="0" cellPadding="0" border="0" width="100%" class="ibn-stylebox">
	<tr>
		<td>
			<ibn:blockheader id="secH" runat="server" title='<%= LocRM.GetString("tbTitle")%>' />
		</td>
	</tr>
	<tr>
		<td>
			<table class="ibn-navline ibn-alternating text" cellSpacing="0" cellPadding="4" width="100%" border="0">
				<tr>
					<td style="PADDING-LEFT: 15px" width="40" class="text"><b>Type:</b></td>
					<td width="160px">
						<asp:DropDownList ID="ddType" Runat="server" CssClass="text" Width="150px"></asp:DropDownList>
					</td>
					<TD class="text" width="40" style="PADDING-LEFT: 15px"><B>Activity:</B>&nbsp;</TD>
					<td width="160px">
						<asp:DropDownList ID="ddActivity" Runat="server" CssClass="text" Width="190px"></asp:DropDownList>
					</td>
					<td style="PADDING-LEFT: 15px">
						<asp:Button ID="btnApply" Runat=server CssClass="text" Width="80px" Text="Apply"></asp:Button>
					</td>
					<td></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td>
			<asp:datagrid AllowSorting=True style="MARGIN-TOP: 10px; MARGIN-LEFT: 5px; MARGIN-RIGHT: 5px" id="SitesList" width="98%" autogeneratecolumns="False" borderwidth="0px" runat="server" GridLines="Horizontal" CellPadding="1" AllowPaging=True PageSize=20>
				<HeaderStyle Wrap="False"></HeaderStyle>
				<Columns>
					<asp:HyperLinkColumn DataNavigateUrlField="company_id" DataNavigateUrlFormatString="../Pages/SiteView.aspx?id={0}" DataTextField="company_name" SortExpression="company_name" HeaderText="Company">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
					</asp:HyperLinkColumn>
					<asp:TemplateColumn HeaderText="Users">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# GetMaxUsers(
							(int)DataBinder.Eval(Container.DataItem,"max_Users"),
							(int)DataBinder.Eval(Container.DataItem,"company_id")
							)%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn HeaderText="Disks Space, MB">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# GetMaxSpace(
							(int)DataBinder.Eval(Container.DataItem,"max_Disk_Space"),
							(int)DataBinder.Eval(Container.DataItem,"company_id")
							)%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:BoundColumn DataField="product_name" SortExpression="product_name" HeaderText="Site">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
					</asp:BoundColumn>
					<asp:BoundColumn DataField="domain" SortExpression="domain" HeaderText="Domain">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
					</asp:BoundColumn>
					<asp:TemplateColumn SortExpression="company_type" HeaderText="Type">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# GetCompanyType((byte)DataBinder.Eval(Container.DataItem,"company_type"))%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn SortExpression="Is_Active" HeaderText="Activity">
						<HeaderStyle HorizontalAlign="Center" CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle HorizontalAlign="Center" CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# GetActivity(
								(bool)DataBinder.Eval(Container.DataItem,"Is_Active")
							)%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:BoundColumn DataField="creation_date" SortExpression="creation_date" HeaderText="Creation Date" DataFormatString="{0:d}">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
					</asp:BoundColumn>
					<asp:TemplateColumn SortExpression="start_date" HeaderText="Start Date">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# GetDate(DataBinder.Eval(Container.DataItem,"start_date"),
										(byte)DataBinder.Eval(Container.DataItem,"company_type")
							)%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn SortExpression="end_date" HeaderText="End Date">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# GetDate(DataBinder.Eval(Container.DataItem,"end_date"),
										(byte)DataBinder.Eval(Container.DataItem,"company_type")
							)%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn SortExpression="use_im" HeaderText="Using IM">
						<HeaderStyle HorizontalAlign="Center" CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle HorizontalAlign="Center" CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# GetUsingIM(
						(bool)DataBinder.Eval(Container.DataItem,"use_im")
							)%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn>
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# GetErrorLogPath(
					(int)DataBinder.Eval(Container.DataItem,"company_id")
							)%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn>
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%#
							GetEditPath
							(
								(int)DataBinder.Eval(Container.DataItem,"company_id")
							)
							%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn>
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# 
							GetDeletePath
							(
								(int)DataBinder.Eval(Container.DataItem,"company_id"),
								DataBinder.Eval(Container.DataItem,"company_name").ToString(),
								DataBinder.Eval(Container.DataItem,"domain").ToString()
							)
							%>
						</ItemTemplate>
					</asp:TemplateColumn>
				</Columns>
				<PagerStyle HorizontalAlign="Right" CssClass="text" Mode="NumericPages"></PagerStyle>
			</asp:datagrid>
		</td>
	</tr>
</TABLE>
<asp:Panel ID="exportPanel" Runat=server Visible=False>
<table cellpadding=2 cellspacing=1>
	<tr height="30px">
		<td class="boldtext"><font class="boldtext" size="3">Companies/Sites List</font></td>
	</tr>
	<tr>
		<td>
			<asp:datagrid id="dgExport" runat="server" width="100%" autogeneratecolumns="False" borderwidth="1px" GridLines="Horizontal" CellPadding="1">
				<Columns>
					<asp:BoundColumn DataField="company_name" HeaderText="Company Name">
						<HeaderStyle CssClass="ibn-vh2" Font-Bold=True></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
					</asp:BoundColumn>
					<asp:TemplateColumn HeaderText="Users">
						<HeaderStyle CssClass="ibn-vh2" Font-Bold=True></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# GetMaxUsers(
							(int)DataBinder.Eval(Container.DataItem,"max_Users"),
							(int)DataBinder.Eval(Container.DataItem,"company_id")
							)%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn HeaderText="Disks Space, MB">
						<HeaderStyle CssClass="ibn-vh2" Font-Bold=True></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# GetMaxSpace(
							(int)DataBinder.Eval(Container.DataItem,"max_Disk_Space"),
							(int)DataBinder.Eval(Container.DataItem,"company_id")
							)%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:BoundColumn DataField="product_name" HeaderText="Site">
						<HeaderStyle CssClass="ibn-vh2" Font-Bold=True></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
					</asp:BoundColumn>
					<asp:BoundColumn DataField="domain" HeaderText="Domain">
						<HeaderStyle CssClass="ibn-vh2" Font-Bold=True></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
					</asp:BoundColumn>
					<asp:TemplateColumn HeaderText="Type">
						<HeaderStyle CssClass="ibn-vh2" Font-Bold=True></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# GetCompanyType((byte)DataBinder.Eval(Container.DataItem,"company_type"))%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:BoundColumn DataField="Is_Active" HeaderText="Activity">
						<HeaderStyle CssClass="ibn-vh2" Font-Bold=True></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
					</asp:BoundColumn>
					<asp:BoundColumn DataField="creation_date" HeaderText="Creation Date" DataFormatString="{0:d}">
						<HeaderStyle CssClass="ibn-vh2" Font-Bold=True></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
					</asp:BoundColumn>
					<asp:TemplateColumn HeaderText="Start Date">
						<HeaderStyle CssClass="ibn-vh2" Font-Bold=True></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# GetDate(DataBinder.Eval(Container.DataItem,"start_date"),
										(byte)DataBinder.Eval(Container.DataItem,"company_type")
							)%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn HeaderText="End Date">
						<HeaderStyle CssClass="ibn-vh2" Font-Bold=True></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# GetDate(DataBinder.Eval(Container.DataItem,"end_date"),
										(byte)DataBinder.Eval(Container.DataItem,"company_type")
							)%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:BoundColumn DataField="use_im" HeaderText="Using IM">
						<HeaderStyle CssClass="ibn-vh2" Font-Bold=True></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
					</asp:BoundColumn>
				</Columns>
			</asp:datagrid>
		</td>
	</tr>
</table>
</asp:Panel>
<asp:LinkButton ID="lbExport" Runat="server" Visible="False"></asp:LinkButton>
<asp:linkbutton id="lbDelete" runat="server" Visible="False">lb</asp:linkbutton>
<input id="txtID" name="txtID" type="hidden" runat="server">
<script language="javascript">
	function DeleteSite(id, tit, domain)
	{
		document.forms[0].<%= txtID.ClientID%>.value = id;
		if (confirm('<%=LocRM.GetString("WarningS")%> "' + tit + '"\r\n<%=LocRM.GetString("WarningS2")%> "' + domain + '" ?'))
			<%=Page.GetPostBackClientEvent(lbDelete,"") %>
	}
</script>
